Window_SkillList.prototype.isEnabled = function(item) {
	var a = [5, 7] //add menu usable skills here!
	if (item) {
		if (a.includes(item.id)) {
			if ($gameVariables.value(41) < item.mpCost) {
				return false
			}
			if ($gameVariables.value(8) < item.tpCost) {
				return false
			}
			return true
		}
	}
	return false
};

Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
    if (this._actor.skillTpCost(skill) > 0) {
        this.changeTextColor(this.normalColor());
        this.drawText(this._actor.skillTpCost(skill), x, y + 16, width, 'right');
    } else if (this._actor.skillMpCost(skill) > 0) {
        this.changeTextColor(this.textColor(24));
        this.drawText(this._actor.skillMpCost(skill), x, y + 16, width, 'right');
    }
};


Window_SkillList.prototype.refresh = function() {
    this.makeItemList();
		
		this._data.sort(function(a, b){
			if (a && b) {
				if (a.occasion == 2 && b.occasion != 2) { return -1}
				if (a.occasion != 2 && b.occasion == 2) { return 1}
				if (a.occasion < b.occasion) { return -1}
				if (a.occasion > b.occasion) { return 1}
				if (a.name.toLowerCase() < b.name.toLowerCase()) { return -1}
				if (a.name.toLowerCase() > b.name.toLowerCase()) { return 1}
			}
			else if (a) {return -1}
			else if (b) {return 1}
			
		 return 0; //default return value (no sorting)
		});

    this.createContents();
    this.drawAllItems();
	
	if (this._data.length == 0) {
        this.changePaintOpacity(0);
        var rect = this.itemRect(0);
        rect.width -= this.textPadding();
		
		this.drawText("(No usable skills)", rect.x + 14, rect.y + 16, rect.width, 'left')
        this.changePaintOpacity(1);
	}
	
};



Scene_Skill.prototype.useItem = function() {
    this.playSeForItem();
	
		if (this.item().mpCost > 0) {
			$gameVariables.setValue(41, $gameVariables.value(41) - this.item().mpCost);
			
			if (pskill(9)) { //polko's blessing
				vset(41, v(41)+1)
			}
			
		}
		if (this.item().tpCost > 0) {
			$gameVariables.setValue(8, $gameVariables.value(8) - this.item().tpCost);
		}
		
		$gameSwitches.setValue(117, true) //refresh hud
	
		$gameVariables.setValue(5, this.item().id);
		$gameTemp.reserveCommonEvent(151)
		
    SceneManager.goto(Scene_Map);		
    this.user().useItem(this.item());
    this._itemWindow.refresh();
};


Scene_Skill.prototype.create = function() {
    Scene_ItemBase.prototype.create.call(this);
    this.createHelpWindow();
    this.createItemWindow();

	if (ConfigManager.touchbuttons) {
		this.sprite = new Sprite(ImageManager.loadPicture('zBtnPrevNext'))
		this.sprite.visible = false
		this.addChild(this.sprite)
		
		this.spriteU = new Sprite(ImageManager.loadPicture('zBtnPrevNextU'))
		this.spriteU.visible = false
		this.addChild(this.spriteU)
		
		this.spriteD = new Sprite(ImageManager.loadPicture('zBtnPrevNextD'))
		this.spriteD.visible = false
		this.addChild(this.spriteD)
		
		this.spriteBack = new Sprite(ImageManager.loadPicture('zBtnBack'))
		this.spriteBack.x = -ConfigManager.movebtn //move x
		this.addChild(this.spriteBack)
	}

		
};


Scene_Skill.prototype.update = function() {
	Scene_ItemBase.prototype.update.call(this)
	if (ConfigManager.touchbuttons && this._itemWindow) {
		var topRow = this._itemWindow.topRow();
		var maxTopRow = this._itemWindow.maxTopRow();
		if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
			this.sprite.visible = true
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
		else if (topRow > 0) {
			this.sprite.visible = false
			this.spriteU.visible = true
			this.spriteD.visible = false
		}
		else if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = true
		}
		else {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
	}
}


Scene_Skill.prototype.start = function() {
    Scene_ItemBase.prototype.start.call(this);
    this._itemWindow.setActor($gameActors.actor(1));
    this._itemWindow.setStypeId(1);
		this._itemWindow.activate();
		this._itemWindow.selectLast();
};

Scene_Skill.prototype.createItemWindow = function() {
    this._itemWindow = new Window_SkillList(62, 28, 692, 448);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
    this._itemWindow.setHandler('cancel', this.popScene.bind(this));
    this.addWindow(this._itemWindow);
};




